# -*- coding: utf-8 -*-
"""
Created on Thu Oct  8 17:09:21 2020



@author: koenv
"""
import os
os.chdir(r'C:\Users\gijn004\OneDrive - Wageningen University & Research\PHD onedrive\4. Papers\3 effluents fractionation\data\MP bars')
# WUR C:\Users\gijn004\OneDrive - Wageningen University & Research\PHD onedrive\4. Papers\3 effluents fractionation\data\MP bars
# home C:\Users\koenv\OneDrive - WageningenUR\PHD onedrive\4. Papers\3 effluents fractionation\data\MP bars
print(os.getcwd())

import pandas as pd
import matplotlib
import matplotlib.pyplot as plt
import numpy as np

fn1 = 'MP bars.xlsx'
fn2 = 'errorbars.xlsx'
xl = pd.ExcelFile(fn1)
sns = xl.sheet_names
colors = ['#e41a1c', '#377eb8', '#4daf4a', '#984ea3', '#ff7f00']         
w = 0.15   #width of the bars
matplotlib.rcParams.update({'font.size': 20})
matplotlib.rc('xtick', labelsize=15) 
matplotlib.rc('ytick', labelsize=15)

# read and arrange data
for sn in sns:
    avdata = pd.read_excel(fn1, sheet_name=sn, header=[0,1], index_col=[0,1])
    erdata = pd.read_excel(fn2, sheet_name=sn, header=[0,1], index_col=[0,1])
    
    headers = list(avdata.columns)
    fractions = []
    doses = []
    for i in headers:
        if i[0] not in fractions:
            fractions += [i[0]]
        if i[1] not in doses:
            doses += [i[1]]
            
    effluents = []
    groups = []
    indexes = list(avdata.index)  
    for i in indexes:
        if i[0] not in effluents:
            effluents += [i[0]]
        if i[1] not in groups:
            groups += [i[1]]   
    xloc = np.arange(len(groups))
# make plot
    fig, axs = plt.subplots(len(fractions),len(doses))
    for i in range(len(fractions)):
        for j in range(len(doses)):
            for n in range(len(effluents)):
                av = avdata[fractions[i]][doses[j]][effluents[n]]
                er = erdata[fractions[i]][doses[j]][effluents[n]]
                axs[i,j].bar(x=xloc-2*w+n*w, height=av, width=w, label=effluents[n], yerr=er, error_kw={'lw':1,'capsize':1}) 

#plot layout    , color=colors[n]              
            axs[i,j].set_ylim([0,100])
            axs[i,j].set_xticks([0,1,2])
            axs[i,j].set_xticklabels(groups) #rotation='vertical'
    for ax in axs.flat:
        ax.label_outer()
    plt.legend(effluents, loc=(1.4,1.1)) 
    fig.text(0.24, 0.9, '0.2', ha='center', va='center')
    fig.text(0.52, 0.9, '0.4', ha='center', va='center')
    fig.text(0.79, 0.9, '0.8', ha='center', va='center')    
    fig.text(0.5, 0.04, 'MP groups', ha='center', va='center')   
    fig.text(0.91, 0.77, fractions[0], ha='left', va='center')
    fig.text(0.91, 0.5, fractions[1], ha='left', va='center')
    fig.text(0.91, 0.23, fractions[2], ha='left', va='center')
    fig.text(0.05, 0.48, 'MP removal (%)', ha='center', va='center', rotation='vertical')
    fig.suptitle('Ozone dose (g O3/g C)')
    fig.set_size_inches(15, 9)

#save    
    fignname = str(sn) + ' MP bars.jpg'
    fig.savefig(fignname, bbox_inches='tight') 


# only complete effluents figure
fig, axs = plt.subplots(1,len(doses))
for m in range(len(groups)):
    for j in range(len(effluents)):
        av = []
        er = []
        dose = []
        for n in range(len(doses)):
            av += [avdata[fractions[0]][doses[n]][effluents[j]][groups[m]]]
            er += [erdata[fractions[0]][doses[n]][effluents[j]][groups[m]]]              
        axs[m].bar(x=xloc-2*w+j*w, height=av, width=w, label=effluents[n], yerr=er, error_kw={'lw':1,'capsize':1})  
    axs[m].set_title(str(groups[m])) # +  ' g O3/g C'
    axs[m].set_ylim([0,100])
    axs[m].set_xticks([0,1,2])
    axs[m].set_xticklabels(doses) #['G1', 'G2', 'G3']# -*- coding: utf-8 -*-                

av
#plot layout    
for ax in axs.flat:
    ax.label_outer()
plt.legend(effluents, loc=(-2.4,-0.6), ncol=5) # right(1.4,1.1) bottom1collumn(-1.1,-1.3) bottom5columns (-2.4,-0.6)
fig.add_subplot(111, frameon=False)
plt.tick_params(labelcolor='none', which='both', top=False, bottom=False, left=False, right=False)
plt.xlabel('Ozone dose (g O3/g C)')
plt.ylabel('MP removal (%)')
plt.title(label = 'MP groups', y=1.2)


#save
fig.set_size_inches(15, 3)
fig.savefig('only Totals', bbox_inches='tight')